package com.hero.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class DisadsPanel extends AbilityPanel {

	private static final long serialVersionUID = 4822707714467319940L;

	public DisadsPanel() {
		super();
	}

	protected void checkIndices() {
		selectionList.checkIndices();
	}

	@Override
	protected GenericObjectList createSelectionList() {
		return new DisadsList();
	}

	@Override
	protected String getAvailableLabel() {
		if (HeroDesigner.getActiveTemplate().is6E()) return "Complications";
		else return "Disadvantages";
	}

	@Override
	protected ArrayList<GenericObject> getAvailableObjects() {
		return HeroDesigner.getActiveTemplate().getDisads();
	}

	@Override
	protected ArrayList<GenericObject> getAvailablePrefabs() {
		return HeroDesigner.getInstance().getPrefabDisads();
	}

	@Override
	protected ArrayList<GenericObject> getObjects() {
		return HeroDesigner.getActiveHero().getDisads();
	}

	@Override
	protected boolean isEquipment() {
		return false;
	}

	@Override
	protected boolean isPower() {
		return false;
	}

	@Override
	public void reset() {
		selectionList.setData(HeroDesigner.getActiveHero().getDisads());
		availableList.setAvailableList(HeroDesigner.getActiveTemplate()
				.getDisads());
		availableTab.setTitleAt(0, HeroDesigner.getActiveTemplate().is6E()?"Complications":"Disadvantages");
	}

	@Override
	public void updateTotal() {
		// check if NCM has been selected....if so, make sure it's in the
		// list...
		if (HeroDesigner.getActiveHero().isNCMSelected()) {
			if (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
					.getDisads(), "NCM") == null) {
				HeroDesigner.getActiveHero().getDisads().add(
						HeroDesigner.getActiveHero().getNCMObject());
				if (HeroDesigner.getActiveHero().getAgeObject() != null) {
					HeroDesigner.getActiveHero().getDisads().add(
							HeroDesigner.getActiveHero().getAgeObject());
				}
			}
			Collections.sort(HeroDesigner.getActiveHero().getDisads(),
					new Comparator() {
						public int compare(Object o1, Object o2) {
							if ((o1 instanceof GenericObject)
									&& (o2 instanceof GenericObject)) {
								GenericObject g1 = (GenericObject) o1;
								GenericObject g2 = (GenericObject) o2;
								return g1.getPosition() - g2.getPosition();
							} else {
								return o1.toString().compareTo(o2.toString());
							}
						}
					});
		} else {
			if (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
					.getDisads(), "NCM") != null) {
				HeroDesigner.getActiveHero().getDisads().remove(
						HeroDesigner.getActiveHero().getNCMObject());
				if (HeroDesigner.getActiveHero().getAgeObject() != null) {
					HeroDesigner.getActiveHero().getDisads().remove(
							HeroDesigner.getActiveHero().getAgeObject());
				}
			}
		}
		super.updateTotal();
	}
}